#include <vector>
#include <iostream>
#include <stack>
#include <queue>

#define INF 1000000

using namespace std;

vector<vector<pair<int, int> > > g;
vector<int> l;
//vector<pair<int, int> > p;
vector<int> tim;
vector<int> edge_cnt;
vector<bool> edge_used;
int n;


int dfs(int v, int max_l, int cur_l = 0)
{
	if(max_l == cur_l)
	{
		if(v == n - 1)
		{
			//edge_cnt[v]++;
			return 1;
		}
		else
			return 0;
	}
	if(max_l < cur_l)
		return 0;
	int ans = 0;
	edge_used[v] = true;
	for(size_t i = 0; i < g[v].size(); i++)
	{
		if(!edge_used[g[v][i].first])
		{
			//cerr << "--edge_cnt[" << g[v][i].second << "] = " << edge_cnt[g[v][i].second] << endl;
			int temp = dfs(g[v][i].first, max_l, cur_l + tim[g[v][i].second]);
			ans += temp;
			edge_cnt[g[v][i].second] += temp;
		}
	}
	edge_used[v] = false;
	return ans;
}

void dijkstra()
{
	priority_queue<pair<int, int> > q;
	q.push(make_pair(0, 0));
	while(!q.empty())
	{
		int v = q.top().second;
		q.pop();
		for(size_t i = 0; i < g[v].size(); i++)
		{
			if(tim[g[v][i].second] + l[v] < l[g[v][i].first])
			{
				//p[g[v][i].first].first = v;
				//p[g[v][i].first].second = g[v][i].second;
				l[g[v][i].first] = tim[g[v][i].second] + l[v];
				q.push(make_pair(l[g[v][i].first], g[v][i].first));
			}
		}
	}
}

int main()
{
	int m;
	ios_base::sync_with_stdio(false);
	cin >> n >> m;
	l = vector<int>(n, INF);
	edge_cnt = vector<int>(m);
	edge_used = vector<bool>(n);
	l[0] = 0;
	pair<int, int> tmp = make_pair(-1, -1);
	//p = vector<pair<int, int> >(n, tmp);
	g = vector<vector<pair<int, int> > >(n);
	int from, to, t;
	for(int i = 0; i < m; i++)
	{
		cin >> from >> to >> t;
		from--;
		to--;
		tim.push_back(t);
		g[from].push_back(make_pair(to, tim.size() - 1));
		g[to].push_back(make_pair(from, tim.size() - 1));
	}
	dijkstra();
	int summary_cnt = dfs(0, l[n-1]);
	queue<int> ans;
	int ans_cnt = 0;
	for(int i = 0; i < m; i++)
	{
		//cerr << "edge_cnt[" << i << "] = " << edge_cnt[i] << endl;
		if(edge_cnt[i] == summary_cnt)
		{
			ans.push(i + 1);
			ans_cnt++;
		}
	}
	cout << ans_cnt << endl;
	while(!ans.empty())
	{
		cout << ans.front() << ' ';
		ans.pop();
	}
	//cin >> n;
	return 0;
}